<?php

namespace App\Modules\Auth\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ResetPasswordRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'phone' => ['required', 'string'],
            'otp' => ['required', 'string', 'size:6'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ];
    }

    protected function prepareForValidation(): void
    {
        if ($this->phone) {
            $phone = preg_replace('/[^0-9]/', '', $this->phone);
            if (str_starts_with($phone, '0')) {
                $phone = '+234' . substr($phone, 1);
            } elseif (!str_starts_with($phone, '234')) {
                $phone = '+234' . $phone;
            } else {
                $phone = '+' . $phone;
            }
            $this->merge(['phone' => $phone]);
        }
    }
}
