<?php

namespace App\Modules\Auth\Requests;

use App\Modules\Auth\Models\OtpVerification;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class VerifyOtpRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'phone' => ['required', 'string'],
            'otp' => ['required', 'string', 'size:6'],
            'purpose' => ['sometimes', 'string', Rule::in([
                OtpVerification::PURPOSE_REGISTRATION,
                OtpVerification::PURPOSE_LOGIN,
                OtpVerification::PURPOSE_PASSWORD_RESET,
                OtpVerification::PURPOSE_PHONE_CHANGE,
            ])],
        ];
    }

    protected function prepareForValidation(): void
    {
        if ($this->phone) {
            $phone = preg_replace('/[^0-9]/', '', $this->phone);
            if (str_starts_with($phone, '0')) {
                $phone = '+234' . substr($phone, 1);
            } elseif (!str_starts_with($phone, '234')) {
                $phone = '+234' . $phone;
            } else {
                $phone = '+' . $phone;
            }
            $this->merge(['phone' => $phone]);
        }
    }
}
