<?php

namespace App\Modules\Auth\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AddressResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'label' => $this->label,
            'address_line_1' => $this->address_line_1,
            'address_line_2' => $this->address_line_2,
            'landmark' => $this->landmark,
            'zone' => $this->when($this->relationLoaded('zone') && $this->zone, [
                'id' => $this->zone?->id,
                'name' => $this->zone?->name,
                'slug' => $this->zone?->slug,
            ]),
            'campus' => $this->when($this->relationLoaded('campus') && $this->campus, [
                'id' => $this->campus?->id,
                'name' => $this->campus?->name,
                'short_name' => $this->campus?->short_name,
            ]),
            'campus_location' => $this->when($this->relationLoaded('campusLocation') && $this->campusLocation, [
                'id' => $this->campusLocation?->id,
                'name' => $this->campusLocation?->name,
                'type' => $this->campusLocation?->type,
            ]),
            'latitude' => $this->latitude,
            'longitude' => $this->longitude,
            'is_default' => $this->is_default,
            'delivery_instructions' => $this->delivery_instructions,
            'full_address' => $this->getFullAddress(),
            'created_at' => $this->created_at?->toIso8601String(),
        ];
    }

    /**
     * Get formatted full address.
     */
    protected function getFullAddress(): string
    {
        $parts = array_filter([
            $this->address_line_1,
            $this->address_line_2,
            $this->campusLocation?->name,
            $this->campus?->short_name ?? $this->campus?->name,
            $this->zone?->name,
        ]);

        return implode(', ', $parts);
    }
}
