<?php

namespace App\Modules\Auth\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->uuid,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'full_name' => $this->full_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'avatar' => $this->avatar ? asset('storage/' . $this->avatar) : null,
            'user_type' => $this->user_type,
            'status' => $this->status,
            'email_verified' => $this->hasVerifiedEmail(),
            'phone_verified' => $this->hasVerifiedPhone(),
            'last_login_at' => $this->last_login_at?->toIso8601String(),
            
            // Customer profile
            'customer' => $this->when($this->relationLoaded('customer') && $this->customer, [
                'referral_code' => $this->customer?->referral_code,
                'total_orders' => $this->customer?->total_orders,
                'total_spent' => $this->customer?->total_spent,
                'loyalty_points' => $this->customer?->loyalty_points,
            ]),
            
            // Wallet
            'wallet' => $this->when($this->relationLoaded('wallet') && $this->wallet, [
                'balance' => number_format($this->wallet?->balance ?? 0, 2),
                'pending_balance' => number_format($this->wallet?->pending_balance ?? 0, 2),
            ]),
            
            // Addresses
            'addresses' => $this->when(
                $this->relationLoaded('addresses'),
                AddressResource::collection($this->addresses)
            ),
            
            // Default address
            'default_address' => $this->when(
                $this->relationLoaded('defaultAddress') && $this->defaultAddress,
                new AddressResource($this->defaultAddress)
            ),
            
            'created_at' => $this->created_at?->toIso8601String(),
        ];
    }
}
