<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('user_addresses', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('zone_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('area_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('campus_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('campus_location_id')->nullable()->constrained()->nullOnDelete();
            
            $table->string('label')->default('Home'); // Home, Work, School
            $table->enum('address_type', ['regular', 'campus'])->default('regular');
            $table->text('address_line_1');
            $table->text('address_line_2')->nullable();
            $table->string('city')->default('Abeokuta');
            $table->string('state')->default('Ogun');
            $table->string('postal_code')->nullable();
            $table->text('landmark')->nullable();
            $table->text('delivery_instructions')->nullable();
            
            // Campus-specific fields
            $table->string('hostel_name')->nullable();
            $table->string('room_number')->nullable();
            $table->string('department_name')->nullable();
            $table->string('building_name')->nullable();
            
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->boolean('is_default')->default(false);
            $table->boolean('is_verified')->default(false);
            $table->timestamps();
            $table->softDeletes();

            $table->index(['user_id', 'is_default']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('user_addresses');
    }
};
