<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('rider_profiles', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('zone_id')->nullable()->constrained()->nullOnDelete();
            
            // Personal Info
            $table->date('date_of_birth')->nullable();
            $table->string('nin')->nullable(); // National ID
            $table->string('drivers_license')->nullable();
            $table->date('license_expiry')->nullable();
            
            // Vehicle Info
            $table->enum('vehicle_type', ['bicycle', 'motorcycle', 'car', 'shuttle'])->default('motorcycle');
            $table->string('vehicle_make')->nullable();
            $table->string('vehicle_model')->nullable();
            $table->string('vehicle_color')->nullable();
            $table->string('vehicle_plate_number')->nullable();
            $table->year('vehicle_year')->nullable();
            
            // Work Info
            $table->boolean('is_online')->default(false);
            $table->boolean('is_available')->default(true);
            $table->decimal('current_latitude', 10, 8)->nullable();
            $table->decimal('current_longitude', 11, 8)->nullable();
            $table->timestamp('last_location_update')->nullable();
            $table->boolean('is_campus_shuttle')->default(false); // Special campus rider
            
            // Stats
            $table->integer('total_deliveries')->default(0);
            $table->decimal('total_earnings', 12, 2)->default(0);
            $table->decimal('rating', 3, 2)->default(5.00);
            $table->integer('rating_count')->default(0);
            
            // Verification
            $table->enum('verification_status', ['pending', 'under_review', 'verified', 'rejected'])->default('pending');
            $table->timestamp('verified_at')->nullable();
            $table->text('rejection_reason')->nullable();
            $table->json('documents')->nullable();
            
            // Bank Details
            $table->string('bank_name')->nullable();
            $table->string('bank_account_number')->nullable();
            $table->string('bank_account_name')->nullable();
            
            $table->timestamps();
            $table->softDeletes();

            $table->index(['is_online', 'is_available', 'zone_id']);
            $table->index(['verification_status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rider_profiles');
    }
};