<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('reviews', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('order_id')->constrained()->cascadeOnDelete();
            
            // Reviewable (Restaurant or Rider)
            $table->morphs('reviewable'); // reviewable_type, reviewable_id
            
            $table->integer('rating'); // 1-5
            $table->text('comment')->nullable();
            $table->json('images')->nullable();
            
            // Specific ratings
            $table->integer('food_rating')->nullable();
            $table->integer('delivery_rating')->nullable();
            $table->integer('packaging_rating')->nullable();
            $table->integer('value_rating')->nullable();
            
            // Vendor Response
            $table->text('vendor_reply')->nullable();
            $table->timestamp('vendor_replied_at')->nullable();
            
            // Moderation
            $table->enum('status', ['pending', 'approved', 'rejected', 'flagged'])->default('approved');
            $table->text('moderation_note')->nullable();
            $table->boolean('is_verified_purchase')->default(true);
            
            $table->timestamps();
            $table->softDeletes();

            $table->index(['reviewable_type', 'reviewable_id', 'status']);
            $table->unique(['user_id', 'order_id', 'reviewable_type', 'reviewable_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('reviews');
    }
};