<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('type');
            $table->morphs('notifiable');
            $table->text('data');
            $table->timestamp('read_at')->nullable();
            $table->timestamps();

            $table->index(['notifiable_type', 'notifiable_id', 'read_at']);
        });

        // Push Notification Logs
        Schema::create('push_notifications', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            
            $table->string('title');
            $table->text('body');
            $table->string('image')->nullable();
            $table->json('data')->nullable();
            $table->string('action_url')->nullable();
            
            $table->enum('type', ['order', 'promo', 'system', 'chat', 'reminder']);
            $table->enum('status', ['pending', 'sent', 'failed', 'clicked'])->default('pending');
            
            $table->string('device_token')->nullable();
            $table->string('platform')->nullable(); // web, android, ios
            $table->string('provider')->default('fcm'); // fcm, pusher, onesignal
            
            $table->string('provider_message_id')->nullable();
            $table->json('provider_response')->nullable();
            
            $table->timestamp('sent_at')->nullable();
            $table->timestamp('clicked_at')->nullable();
            $table->timestamps();

            $table->index(['user_id', 'status', 'created_at']);
        });

        // Broadcast Notifications (mass notifications)
        Schema::create('broadcast_notifications', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->foreignId('created_by')->constrained('users')->cascadeOnDelete();
            
            $table->string('title');
            $table->text('body');
            $table->string('image')->nullable();
            $table->json('data')->nullable();
            $table->string('action_url')->nullable();
            
            $table->enum('target_audience', ['all', 'customers', 'vendors', 'riders', 'zone', 'custom']);
            $table->json('target_zones')->nullable();
            $table->json('target_user_ids')->nullable();
            
            $table->enum('status', ['draft', 'scheduled', 'sending', 'sent', 'failed'])->default('draft');
            $table->timestamp('scheduled_for')->nullable();
            $table->timestamp('sent_at')->nullable();
            
            $table->integer('total_recipients')->default(0);
            $table->integer('successful_deliveries')->default(0);
            $table->integer('failed_deliveries')->default(0);
            
            $table->timestamps();

            $table->index(['status', 'scheduled_for']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('broadcast_notifications');
        Schema::dropIfExists('push_notifications');
        Schema::dropIfExists('notifications');
    }
};