<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->foreignId('created_by')->constrained('users')->cascadeOnDelete();
            $table->foreignId('restaurant_id')->nullable()->constrained()->nullOnDelete();
            
            $table->string('code')->unique();
            $table->string('name');
            $table->text('description')->nullable();
            
            $table->enum('type', ['percentage', 'fixed', 'free_delivery']);
            $table->decimal('value', 10, 2); // Percentage or fixed amount
            $table->decimal('max_discount', 10, 2)->nullable(); // Cap for percentage discounts
            $table->decimal('minimum_order', 10, 2)->default(0);
            
            // Validity
            $table->timestamp('starts_at')->nullable();
            $table->timestamp('expires_at')->nullable();
            
            // Usage Limits
            $table->integer('max_uses')->nullable(); // Total uses
            $table->integer('max_uses_per_user')->default(1);
            $table->integer('times_used')->default(0);
            
            // Targeting
            $table->boolean('is_public')->default(true);
            $table->boolean('first_order_only')->default(false);
            $table->json('applicable_zones')->nullable();
            $table->json('applicable_restaurants')->nullable();
            $table->json('applicable_categories')->nullable();
            $table->json('excluded_items')->nullable();
            
            $table->enum('status', ['active', 'inactive', 'expired'])->default('active');
            $table->timestamps();
            $table->softDeletes();

            $table->index(['code', 'status']);
            $table->index(['status', 'starts_at', 'expires_at']);
        });

        // Coupon Usage Log
        Schema::create('coupon_usages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('coupon_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('order_id')->constrained()->cascadeOnDelete();
            $table->decimal('discount_amount', 10, 2);
            $table->timestamps();

            $table->index(['coupon_id', 'user_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('coupon_usages');
        Schema::dropIfExists('coupons');
    }
};
