<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application.
| These routes are loaded by the RouteServiceProvider and all of them
| will be assigned to the "api" middleware group.
|
*/

// API Version 1
Route::prefix('v1')->group(function () {
    // Auth routes
    Route::prefix('auth')->group(base_path('routes/api/v1/auth.php'));
    
    // Customer routes
    Route::prefix('customer')->group(base_path('routes/api/v1/customer.php'));
    
    // Vendor routes
    Route::prefix('vendor')->group(base_path('routes/api/v1/vendor.php'));
    
    // Rider routes
    Route::prefix('rider')->group(base_path('routes/api/v1/rider.php'));
    
    // Admin routes
    Route::prefix('admin')->group(base_path('routes/api/v1/admin.php'));
});

// Health check
Route::get('/health', function () {
    return response()->json([
        'status' => 'healthy',
        'timestamp' => now()->toIso8601String(),
        'version' => config('app.version', '1.0.0'),
    ]);
})->name('health');
