<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Admin API Routes
|--------------------------------------------------------------------------
|
| Routes for admin backoffice panel.
| All routes are prefixed with /api/v1/admin
|
*/

Route::middleware(['auth:sanctum', 'user.type:admin'])->group(function () {
    // Dashboard
    Route::get('/dashboard', 'DashboardController@index')->name('admin.dashboard');
    Route::get('/dashboard/stats', 'DashboardController@stats')->name('admin.dashboard.stats');
    Route::get('/dashboard/charts', 'DashboardController@charts')->name('admin.dashboard.charts');
    Route::get('/dashboard/recent-activity', 'DashboardController@recentActivity')->name('admin.dashboard.activity');

    // User Management
    Route::prefix('users')->group(function () {
        Route::get('/', 'UserController@index')->name('admin.users.index');
        Route::get('/{uuid}', 'UserController@show')->name('admin.users.show');
        Route::put('/{uuid}', 'UserController@update')->name('admin.users.update');
        Route::post('/{uuid}/suspend', 'UserController@suspend')->name('admin.users.suspend');
        Route::post('/{uuid}/activate', 'UserController@activate')->name('admin.users.activate');
        Route::delete('/{uuid}', 'UserController@destroy')->name('admin.users.destroy');
    });

    // Vendor Management
    Route::prefix('vendors')->group(function () {
        Route::get('/', 'VendorController@index')->name('admin.vendors.index');
        Route::get('/pending', 'VendorController@pending')->name('admin.vendors.pending');
        Route::get('/{id}', 'VendorController@show')->name('admin.vendors.show');
        Route::put('/{id}', 'VendorController@update')->name('admin.vendors.update');
        Route::post('/{id}/approve', 'VendorController@approve')->name('admin.vendors.approve');
        Route::post('/{id}/reject', 'VendorController@reject')->name('admin.vendors.reject');
        Route::post('/{id}/suspend', 'VendorController@suspend')->name('admin.vendors.suspend');
        Route::get('/{id}/documents', 'VendorController@documents')->name('admin.vendors.documents');
        Route::post('/{id}/documents/{docId}/approve', 'VendorController@approveDocument')->name('admin.vendors.approve-document');
        Route::post('/{id}/documents/{docId}/reject', 'VendorController@rejectDocument')->name('admin.vendors.reject-document');
    });

    // Restaurant Management
    Route::prefix('restaurants')->group(function () {
        Route::get('/', 'RestaurantController@index')->name('admin.restaurants.index');
        Route::get('/{uuid}', 'RestaurantController@show')->name('admin.restaurants.show');
        Route::put('/{uuid}', 'RestaurantController@update')->name('admin.restaurants.update');
        Route::post('/{uuid}/approve', 'RestaurantController@approve')->name('admin.restaurants.approve');
        Route::post('/{uuid}/suspend', 'RestaurantController@suspend')->name('admin.restaurants.suspend');
        Route::post('/{uuid}/feature', 'RestaurantController@toggleFeatured')->name('admin.restaurants.feature');
        Route::get('/{uuid}/menu', 'RestaurantController@menu')->name('admin.restaurants.menu');
    });

    // Rider Management
    Route::prefix('riders')->group(function () {
        Route::get('/', 'RiderController@index')->name('admin.riders.index');
        Route::get('/pending', 'RiderController@pending')->name('admin.riders.pending');
        Route::get('/online', 'RiderController@online')->name('admin.riders.online');
        Route::get('/{id}', 'RiderController@show')->name('admin.riders.show');
        Route::put('/{id}', 'RiderController@update')->name('admin.riders.update');
        Route::post('/{id}/approve', 'RiderController@approve')->name('admin.riders.approve');
        Route::post('/{id}/reject', 'RiderController@reject')->name('admin.riders.reject');
        Route::post('/{id}/suspend', 'RiderController@suspend')->name('admin.riders.suspend');
        Route::get('/{id}/documents', 'RiderController@documents')->name('admin.riders.documents');
        Route::get('/{id}/performance', 'RiderController@performance')->name('admin.riders.performance');
    });

    // Order Management
    Route::prefix('orders')->group(function () {
        Route::get('/', 'OrderController@index')->name('admin.orders.index');
        Route::get('/stats', 'OrderController@stats')->name('admin.orders.stats');
        Route::get('/{uuid}', 'OrderController@show')->name('admin.orders.show');
        Route::post('/{uuid}/assign-rider', 'OrderController@assignRider')->name('admin.orders.assign-rider');
        Route::post('/{uuid}/cancel', 'OrderController@cancel')->name('admin.orders.cancel');
        Route::post('/{uuid}/refund', 'OrderController@refund')->name('admin.orders.refund');
    });

    // Finance
    Route::prefix('finance')->group(function () {
        Route::get('/overview', 'FinanceController@overview')->name('admin.finance.overview');
        Route::get('/revenue', 'FinanceController@revenue')->name('admin.finance.revenue');
        
        // Settlements
        Route::get('/settlements', 'FinanceController@settlements')->name('admin.finance.settlements');
        Route::get('/settlements/{uuid}', 'FinanceController@settlementDetails')->name('admin.finance.settlement-details');
        Route::post('/settlements/{uuid}/process', 'FinanceController@processSettlement')->name('admin.finance.process-settlement');
        Route::post('/settlements/batch-process', 'FinanceController@batchProcessSettlements')->name('admin.finance.batch-process');
        
        // Withdrawals
        Route::get('/withdrawals', 'FinanceController@withdrawals')->name('admin.finance.withdrawals');
        Route::post('/withdrawals/{uuid}/approve', 'FinanceController@approveWithdrawal')->name('admin.finance.approve-withdrawal');
        Route::post('/withdrawals/{uuid}/reject', 'FinanceController@rejectWithdrawal')->name('admin.finance.reject-withdrawal');
    });

    // Zone Management
    Route::prefix('zones')->group(function () {
        Route::get('/', 'ZoneController@index')->name('admin.zones.index');
        Route::post('/', 'ZoneController@store')->name('admin.zones.store');
        Route::get('/{id}', 'ZoneController@show')->name('admin.zones.show');
        Route::put('/{id}', 'ZoneController@update')->name('admin.zones.update');
        Route::delete('/{id}', 'ZoneController@destroy')->name('admin.zones.destroy');
        Route::put('/{id}/delivery-fees', 'ZoneController@updateDeliveryFees')->name('admin.zones.delivery-fees');
    });

    // Campus Management
    Route::prefix('campuses')->group(function () {
        Route::get('/', 'CampusController@index')->name('admin.campuses.index');
        Route::post('/', 'CampusController@store')->name('admin.campuses.store');
        Route::get('/{id}', 'CampusController@show')->name('admin.campuses.show');
        Route::put('/{id}', 'CampusController@update')->name('admin.campuses.update');
        Route::delete('/{id}', 'CampusController@destroy')->name('admin.campuses.destroy');
        
        // Campus Locations
        Route::get('/{id}/locations', 'CampusLocationController@index')->name('admin.campuses.locations.index');
        Route::post('/{id}/locations', 'CampusLocationController@store')->name('admin.campuses.locations.store');
        Route::put('/locations/{locationId}', 'CampusLocationController@update')->name('admin.campuses.locations.update');
        Route::delete('/locations/{locationId}', 'CampusLocationController@destroy')->name('admin.campuses.locations.destroy');
    });

    // Ads Management
    Route::prefix('ads')->group(function () {
        Route::get('/', 'AdsController@index')->name('admin.ads.index');
        Route::post('/', 'AdsController@store')->name('admin.ads.store');
        Route::get('/positions', 'AdsController@positions')->name('admin.ads.positions');
        Route::get('/{uuid}', 'AdsController@show')->name('admin.ads.show');
        Route::put('/{uuid}', 'AdsController@update')->name('admin.ads.update');
        Route::delete('/{uuid}', 'AdsController@destroy')->name('admin.ads.destroy');
        Route::post('/{uuid}/approve', 'AdsController@approve')->name('admin.ads.approve');
        Route::post('/{uuid}/reject', 'AdsController@reject')->name('admin.ads.reject');
        Route::get('/{uuid}/stats', 'AdsController@stats')->name('admin.ads.stats');
    });

    // Coupon Management
    Route::prefix('coupons')->group(function () {
        Route::get('/', 'CouponController@index')->name('admin.coupons.index');
        Route::post('/', 'CouponController@store')->name('admin.coupons.store');
        Route::get('/{id}', 'CouponController@show')->name('admin.coupons.show');
        Route::put('/{id}', 'CouponController@update')->name('admin.coupons.update');
        Route::delete('/{id}', 'CouponController@destroy')->name('admin.coupons.destroy');
        Route::post('/{id}/toggle', 'CouponController@toggle')->name('admin.coupons.toggle');
        Route::get('/{id}/usage', 'CouponController@usage')->name('admin.coupons.usage');
    });

    // CMS
    Route::prefix('cms')->group(function () {
        Route::get('/pages', 'CmsController@pages')->name('admin.cms.pages');
        Route::post('/pages', 'CmsController@createPage')->name('admin.cms.create-page');
        Route::put('/pages/{id}', 'CmsController@updatePage')->name('admin.cms.update-page');
        Route::delete('/pages/{id}', 'CmsController@deletePage')->name('admin.cms.delete-page');
        
        Route::get('/faqs', 'CmsController@faqs')->name('admin.cms.faqs');
        Route::post('/faqs', 'CmsController@createFaq')->name('admin.cms.create-faq');
        Route::put('/faqs/{id}', 'CmsController@updateFaq')->name('admin.cms.update-faq');
        Route::delete('/faqs/{id}', 'CmsController@deleteFaq')->name('admin.cms.delete-faq');
    });

    // Push Notifications
    Route::prefix('notifications')->group(function () {
        Route::get('/', 'NotificationController@index')->name('admin.notifications.index');
        Route::post('/send', 'NotificationController@send')->name('admin.notifications.send');
        Route::post('/send-bulk', 'NotificationController@sendBulk')->name('admin.notifications.send-bulk');
    });

    // Settings
    Route::prefix('settings')->group(function () {
        Route::get('/', 'SettingController@index')->name('admin.settings.index');
        Route::get('/group/{group}', 'SettingController@group')->name('admin.settings.group');
        Route::put('/', 'SettingController@update')->name('admin.settings.update');
    });

    // Reports
    Route::prefix('reports')->group(function () {
        Route::get('/sales', 'ReportController@sales')->name('admin.reports.sales');
        Route::get('/orders', 'ReportController@orders')->name('admin.reports.orders');
        Route::get('/vendors', 'ReportController@vendors')->name('admin.reports.vendors');
        Route::get('/riders', 'ReportController@riders')->name('admin.reports.riders');
        Route::get('/customers', 'ReportController@customers')->name('admin.reports.customers');
        Route::post('/export', 'ReportController@export')->name('admin.reports.export');
    });

    // Activity Logs
    Route::prefix('logs')->group(function () {
        Route::get('/', 'LogController@index')->name('admin.logs.index');
        Route::get('/system', 'LogController@system')->name('admin.logs.system');
    });

    // Role & Permission Management
    Route::prefix('roles')->group(function () {
        Route::get('/', 'RoleController@index')->name('admin.roles.index');
        Route::post('/', 'RoleController@store')->name('admin.roles.store');
        Route::get('/{id}', 'RoleController@show')->name('admin.roles.show');
        Route::put('/{id}', 'RoleController@update')->name('admin.roles.update');
        Route::delete('/{id}', 'RoleController@destroy')->name('admin.roles.destroy');
        Route::get('/permissions', 'RoleController@permissions')->name('admin.roles.permissions');
    });
});
