<?php

use App\Modules\Auth\Controllers\AuthController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Auth API Routes
|--------------------------------------------------------------------------
|
| These routes handle authentication for the CampusEats platform.
| All routes are prefixed with /api/v1/auth
|
*/

// Guest routes (unauthenticated)
Route::middleware(['guest', 'throttle:auth'])->group(function () {
    // Registration
    Route::post('/register', [AuthController::class, 'register'])
        ->name('auth.register');

    // Login
    Route::post('/login', [AuthController::class, 'login'])
        ->name('auth.login');

    // OTP Login (passwordless)
    Route::post('/login/otp', [AuthController::class, 'requestOtpLogin'])
        ->name('auth.login.otp');

    // Verify OTP
    Route::post('/verify-otp', [AuthController::class, 'verifyOtp'])
        ->name('auth.verify-otp');

    // Resend OTP
    Route::post('/resend-otp', [AuthController::class, 'resendOtp'])
        ->name('auth.resend-otp');

    // Forgot Password
    Route::post('/forgot-password', [AuthController::class, 'forgotPassword'])
        ->name('auth.forgot-password');

    // Reset Password
    Route::post('/reset-password', [AuthController::class, 'resetPassword'])
        ->name('auth.reset-password');
});

// Authenticated routes
Route::middleware(['auth:sanctum'])->group(function () {
    // Get current user
    Route::get('/user', [AuthController::class, 'user'])
        ->name('auth.user');

    // Update profile
    Route::put('/profile', [AuthController::class, 'updateProfile'])
        ->name('auth.profile.update');

    // Change password
    Route::post('/change-password', [AuthController::class, 'changePassword'])
        ->name('auth.change-password');

    // Update device token
    Route::post('/device-token', [AuthController::class, 'updateDeviceToken'])
        ->name('auth.device-token');

    // Logout
    Route::post('/logout', [AuthController::class, 'logout'])
        ->name('auth.logout');

    // Logout from all devices
    Route::post('/logout-all', [AuthController::class, 'logoutAll'])
        ->name('auth.logout-all');
});
