<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Rider API Routes
|--------------------------------------------------------------------------
|
| Routes for delivery rider app.
| All routes are prefixed with /api/v1/rider
|
*/

// Rider Registration (guest)
Route::post('/register', 'RiderAuthController@register')
    ->middleware(['throttle:auth'])
    ->name('rider.register');

// Authenticated rider routes
Route::middleware(['auth:sanctum', 'user.type:rider'])->group(function () {
    // Dashboard
    Route::get('/dashboard', 'DashboardController@index')->name('rider.dashboard');
    Route::get('/dashboard/stats', 'DashboardController@stats')->name('rider.dashboard.stats');
    Route::get('/dashboard/summary', 'DashboardController@dailySummary')->name('rider.dashboard.summary');

    // Profile & KYC
    Route::prefix('profile')->group(function () {
        Route::get('/', 'ProfileController@show')->name('rider.profile.show');
        Route::put('/', 'ProfileController@update')->name('rider.profile.update');
        Route::post('/documents', 'ProfileController@uploadDocument')->name('rider.profile.upload-document');
        Route::get('/documents', 'ProfileController@documents')->name('rider.profile.documents');
        Route::put('/vehicle', 'ProfileController@updateVehicle')->name('rider.profile.update-vehicle');
    });

    // Availability
    Route::prefix('availability')->group(function () {
        Route::get('/status', 'AvailabilityController@status')->name('rider.availability.status');
        Route::post('/online', 'AvailabilityController@goOnline')->name('rider.availability.online');
        Route::post('/offline', 'AvailabilityController@goOffline')->name('rider.availability.offline');
        Route::post('/location', 'AvailabilityController@updateLocation')->name('rider.availability.location');
    });

    // Deliveries
    Route::prefix('deliveries')->group(function () {
        Route::get('/available', 'DeliveryController@available')->name('rider.deliveries.available');
        Route::get('/active', 'DeliveryController@active')->name('rider.deliveries.active');
        Route::get('/history', 'DeliveryController@history')->name('rider.deliveries.history');
        Route::get('/{uuid}', 'DeliveryController@show')->name('rider.deliveries.show');
        Route::post('/{uuid}/accept', 'DeliveryController@accept')->name('rider.deliveries.accept');
        Route::post('/{uuid}/reject', 'DeliveryController@reject')->name('rider.deliveries.reject');
        Route::post('/{uuid}/pickup', 'DeliveryController@pickup')->name('rider.deliveries.pickup');
        Route::post('/{uuid}/deliver', 'DeliveryController@deliver')->name('rider.deliveries.deliver');
        Route::post('/{uuid}/location', 'DeliveryController@updateDeliveryLocation')->name('rider.deliveries.update-location');
    });

    // Wallet & Earnings
    Route::prefix('wallet')->group(function () {
        Route::get('/', 'WalletController@show')->name('rider.wallet.show');
        Route::get('/transactions', 'WalletController@transactions')->name('rider.wallet.transactions');
        Route::get('/earnings', 'WalletController@earnings')->name('rider.wallet.earnings');
        Route::post('/withdraw', 'WalletController@requestWithdrawal')->name('rider.wallet.withdraw');
        Route::get('/withdrawals', 'WalletController@withdrawals')->name('rider.wallet.withdrawals');
    });

    // Performance
    Route::prefix('performance')->group(function () {
        Route::get('/', 'PerformanceController@index')->name('rider.performance.index');
        Route::get('/ratings', 'PerformanceController@ratings')->name('rider.performance.ratings');
        Route::get('/history', 'PerformanceController@history')->name('rider.performance.history');
    });

    // Chat
    Route::prefix('chat')->group(function () {
        Route::get('/conversations', 'ChatController@conversations')->name('rider.chat.conversations');
        Route::get('/conversations/{uuid}', 'ChatController@show')->name('rider.chat.show');
        Route::post('/conversations/{uuid}/messages', 'ChatController@sendMessage')->name('rider.chat.send');
    });

    // Notifications
    Route::prefix('notifications')->group(function () {
        Route::get('/', 'NotificationController@index')->name('rider.notifications.index');
        Route::post('/{id}/read', 'NotificationController@markAsRead')->name('rider.notifications.read');
        Route::post('/read-all', 'NotificationController@markAllAsRead')->name('rider.notifications.read-all');
    });
});
